<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo $__env->yieldContent('title', 'Admin Panel'); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap 3 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

    <!-- Custom Styles -->

    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>


    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background-color: #ecf0f1;
            padding-top: 50px;
            color: #2c3e50;
        }
        .navbar-inverse {
            background-color: #2c3e50;
            border: none;
        }
        .navbar-inverse .navbar-brand,
        .navbar-inverse .navbar-nav > li > a {
            color: #ecf0f1;
        }
        .sidebar {
            position: fixed;
            top: 50px;
            left: 0;
            bottom: 0;
            width: 230px;
            background: #34495e;
            padding-top: 20px;
            overflow-y: auto;
        }
        .sidebar .nav-header {
            text-transform: uppercase;
            color: #bdc3c7;
            font-size: 12px;
            padding: 10px 20px;
        }
        .sidebar a {
            display: block;
            color: #ecf0f1;
            padding: 12px 20px;
            font-size: 14px;
            border-left: 4px solid transparent;
            transition: all 0.3s;
        }
        .sidebar a:hover,
        .sidebar a.active {
            background-color: #1abc9c;
            color: white;
            border-left: 4px solid #16a085;
            text-decoration: none;
        }
        .main {
            margin-left: 230px;
            padding: 30px;
        }
        .page-header {
            margin-top: 0;
            padding-bottom: 10px;
            border-bottom: 2px solid #bdc3c7;
        }
        .info-card {
            background: #fff;
            padding: 20px;
            margin-bottom: 20px;
            border-left: 5px solid #3498db;
            border-radius: 4px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        .info-card h4 {
            margin-top: 0;
        }
        .info-card .icon {
            font-size: 28px;
            float: right;
            color: #3498db;
        }
        .panel-heading {
            background-color: #2c3e50 !important;
            color: white !important;
            font-weight: bold;
        }
        @media (max-width: 991px) {
            .main {
                margin-left: 0;
                padding: 20px;
            }
            .sidebar {
                width: 100%;
                position: relative;
                height: auto;
                z-index: 1000;
            }
            .sidebar a {
                padding: 10px 15px;
                font-size: 13px;
            }
        }
        @media (max-width: 767px) {
            .info-card {
                text-align: center;
            }
            .info-card .icon {
                float: none;
                display: block;
                margin: 10px auto;
            }
        }
    </style>
</head>
<body>

<!-- Navbar -->
<nav class="navbar navbar-inverse navbar-fixed-top">
  <div class="container-fluid">
    <div class="navbar-header">
      <button type="button"
              class="navbar-toggle collapsed"
              data-toggle="collapse"
              data-target="#navbar"
              aria-expanded="false">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <a class="navbar-brand" href="#">BIGBOY CRM</a>
    </div>

    <div class="collapse navbar-collapse" id="navbar">
      <ul class="nav navbar-nav">
        <li><a href="<?php echo e(url('/home' )); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Help</a></li>
      </ul>
      <ul class="nav navbar-nav navbar-right">
        <li><a href="#"><i class="fa fa-user"></i> <?php echo e(Auth::user()->name); ?>

    </a></li>
        <li class="dropdown">
          <a href="#" class="dropdown-toggle" data-toggle="dropdown">
            <i class="fa fa-cog"></i> Settings <span class="caret"></span>
          </a>
          <ul class="dropdown-menu">
            <li><a href="<?php echo e(url('statuses')); ?>">Manage Events</a></li>
            <li><a href="<?php echo e(url('change-password')); ?>">Change Password</a></li>
            
            <li><a href="<?php echo e(url('whatsapp-link')); ?>" onclick="window.open(this.href, '_blank', 'width=800,height=600'); return false;">Link Whatsapp</a></li>
            
          </ul>
        </li>
        
        <li class="dropdown">
          <a href="#" class="dropdown-toggle" data-toggle="dropdown">
            <i class="fa fa-cog"></i> Admin console <span class="caret"></span>
          </a>
          <ul class="dropdown-menu">
            <li><a href="<?php echo e(url('users/create')); ?>">Manage Users</a></li>
          </ul>
        </li>
        
        
        
        
        <li>
            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                <?php echo csrf_field(); ?>
            </form>
            <a href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                <i class="fa fa-sign-out"></i> Logout
            </a>
            </li>
      </ul>
    </div>
  </div>
</nav>

<!-- Sidebar -->
<div class="sidebar">
    <div class="nav-header">Events</div>
    <a href="<?php echo e(url('/upload-applicants')); ?>"
   class="<?php echo e(request()->is('upload-applicants') ? 'active' : ''); ?>">
    <span class="glyphicon glyphicon-upload"></span> Import Leads (CSV)
    </a>

    <?php if(isset($statuses) && $statuses->count()): ?>
        <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <a href="<?php echo e(url('/applicants')); ?>?status=<?php echo e($status->status); ?>&label= <?php echo e($status->status_name); ?>"
        class="<?php echo e(request('status') === $status->status ? 'active' : ''); ?>">
        <span class="glyphicon glyphicon-floppy-disk"></span> <?php echo e($status->status_name); ?>

        </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <a href="#"><i class="fa fa-exclamation-circle"></i> No Menu Found</a>
    <?php endif; ?>
</div>

<!-- Main Content -->
<div class="main">
<?php /**PATH /home/crmbigboyschool/public_html/crm/resources/views/layouts/header.blade.php ENDPATH**/ ?>