<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="panel panel-primary">
      <div class="panel-heading">All Events</div>
      <div class="panel-body">
            <a href="<?php echo e(route('statuses.create')); ?>" class="btn btn-primary mb-3">Add Event</a>
                <br></br>
                <?php if(session('success')): ?>
                    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                <?php endif; ?>
            
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Event Name</th>
                            <th>Event Code</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($status->status_name); ?></td>
                            <td><?php echo e($status->status); ?></td>
                            <td>
                                <form action="<?php echo e(route('statuses.destroy', $status->id)); ?>" method="POST" onsubmit="return confirm('Are you sure to delete this status?');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button class="btn btn-danger btn-sm">Delete</button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
      </div>
</div>

<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/crmbigboyschool/public_html/crm/resources/views/statuses/index.blade.php ENDPATH**/ ?>