<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="panel panel-primary">
    <div class="panel-heading">Edit Application</div>
    <div class="panel-body">
        <div class="container my-5">
            <div class="row justify-content-center">
                <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissable">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <?php echo e(session('success')); ?>

    </div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissable">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <?php echo e(session('error')); ?>

    </div>
<?php endif; ?>

<?php if($errors->any()): ?>
    <div class="alert alert-danger alert-dismissable">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <strong>Whoops! Something went wrong:</strong>
        <ul class="mb-0 mt-2">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

                <div class="col-md-10">
                    <form action="<?php echo e(route('applicants.update', $applicant->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <div class="card shadow-lg border-0 rounded-4 bg-white">
                            <div class="card-body p-4 bg-light-subtle">
                                <div class="panel panel-primary">
                                  <div class="panel-heading">Update Lead</div>
                                  <div class="panel-body">
                                      
                                      <table class="table table-bordered">
                                    <tbody>
                                        <tr style="background-color: #e0ebeb;">
                                            <th style="width: 250px;">Name</th>
                                            <td><input type="text" name="name" value="<?php echo e($applicant->name); ?>" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Qualification</th>
                                            <td><input type="text" name="qualification" value="<?php echo e($applicant->qualification); ?>" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Phone</th>
                                            <td><input type="text" name="phone" value="<?php echo e($applicant->phone); ?>" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Email</th>
                                            <td><input type="text" name="email" value="<?php echo e($applicant->email); ?>" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Address</th>
                                            <td><textarea name="address" class="form-control" rows="2"><?php echo e($applicant->address); ?></textarea></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Attended by </th>
                                            <td>
                                                <div class="alert alert-info">
                                               <span class="glyphicon glyphicon-user"></span>
                                               <?php echo e($applicant->asigned_to); ?>

                                            </div>
                                                
                                            </td>
                                        </tr>
                                        <th style="background-color: #e0ebeb;">
                                            Course
                                        </th>
                                        <td>
                                             <select class="form-control" name="course">
                                                    <option>-Add or change course-</option>
                                                    <?php
                                                    foreach($courses as $course)
                                                    {
                                                        ?>
                                                        <option value="<?php echo e($course->Name); ?>"><?php echo e($course->Name); ?></option>
                                                        <?php
                                                    }
                                                    ?>
                                             </select>
                                        </td>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Course Selected</th>
                                        <td>
                                            
                                            <div class="alert alert-info">
                                               <?php echo e($applicant->course); ?>

                                            </div>
                                            
                                            </td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Created From</th>
                                            <td><input type="text" name="created_from" value="<?php echo e($applicant->created_from); ?>" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Status</th>
                                            <td>
                                                <select name="status" class="form-control">
                                                    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($status->status); ?>" <?php echo e($applicant->status === $status->status ? 'selected' : ''); ?>>
                                                            <?php echo e($status->status_name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Notes</th>
                                            <td><textarea name="notes" id="notes" class="form-control" rows="3"><?php echo e($applicant->notes); ?></textarea></td>
                                        </tr>
                                        <tr>
                                            <th>Scheduled to </th>
                                            <td>
                                                
                                                <input class="form-control" type="date" value = "<?php echo e($applicant->scheduled_to); ?>" name="scheduled_to">
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2" class="text-end">
                                                <a href="<?php echo e(route('applicants.index')); ?>" class="btn btn-outline-secondary">Cancel</a>
                                                <button type="submit" class="btn btn-primary px-4">Update Lead</button>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                      
                                      
                                  </div>
                                </div>
                                
                                
                                
                                
                                

                            </div>
                        </div>
                    </form>
                    <table class="table table-bordered">
                        <tr>
                                            <td colspan="2">
                                                
                                                <div class="panel panel-primary">
                                          <div class="panel-heading">Followups</div>
                                          <div class="panel-body">
                                              <table class="table table-bordered">
                                                  <tr>
                                                      <th>Id</th>
                                                      <th>Application</th>
                                                      <td>Followup Date</td>
                                                      <th>Reason</th>
                                                      <th>Status</th>
                                                      <th>Action</th>
                                                  </tr>
                                              <?php
                                              
                                                  
                                                  foreach($followups as     $followup)
                                            {
                                              ?>
                                              <tr>
                                                  <form action="<?php echo e(route('followups.update')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                                  <td><input name="id" type="hidden" value="<?php echo e($followup->id); ?>"><?php echo e($followup->id); ?></td>
                                                  <td><?php echo e($followup->application_id); ?></td>
                                                  <td><?php echo e($followup->followup_date); ?></td>
                                                  <td><?php echo e($followup->followup_reason); ?></td>
                                                  <td>
                                                      <select name="status" class="form-control">
                                                          <option <?php if ($followup->status == "Pending"){ echo "selected";} ?>>Pending    </option>
                                                          <option <?php if ($followup->status == "Done"){ echo "selected";} ?>>Done</option>
                                                          
                                                      </select>
                                                  </td>
                                                  <td><button class="btn btn-primary px-4">Update</button></td>
                                              </tr>
                                              <?php
                                              }
                                              ?>
                                              </table> 
                                             
                                          </div>
                                        </div>
                                                
                                                
                                            </td>
                                        </form>
                                        </tr>
                                        <tr>
                                            <td colspan="2">
                                                <div class="panel panel-primary">
                                          <div class="panel-heading">New followup</div>
                                          <div class="panel-body">
                                              
                                              <form action="<?php echo e(route('followups.store')); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <label>Application ID:</label><br>
                                            <input value="<?php echo e($applicant->id); ?>" readonly type="number" name="application_id" required class="form-control"><br>
                                    
                                            <label>Followup Date:</label><br>
                                            <input class="form-control" type="date" name="followup_date" required><br>
                                    
                                            <label>Followup Reason:</label><br>
                                            <input class="form-control" type="text" name="followup_reason" required><br>
                                    
                                            <label>Status:</label><br>
                                            <select class="form-control" name="status">
                                                <option value="pending">Pending</option>
                                                <option value="Done">Done</option>
                                                
                                            </select><br>
                                    
                                            <button class="btn btn-success px-4" type="submit">Create</button>
                                        </form>
                                              
                                          </div>
                                        </div>
                                                 
                                            </td>
                                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- CKEditor Script -->
<script src="https://cdn.ckeditor.com/4.20.2/standard/ckeditor.js"></script>
<script>
    CKEDITOR.replace('notes');
</script>

<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/crmbigboyschool/public_html/crm/resources/views/applicants/edit.blade.php ENDPATH**/ ?>