<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="panel panel-primary">
    <div class="panel-heading">Edit Application</div>
    <div class="panel-body">
        <div class="container my-5">
            <div class="row justify-content-center">
                <div class="col-md-10">
                    <form action="<?php echo e(route('applicants.update', $applicant->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <div class="card shadow-lg border-0 rounded-4 bg-white">
                            <div class="card-body p-4 bg-light-subtle">

                                <table class="table table-bordered">
                                    <tbody>
                                        <tr style="background-color: #e0ebeb;">
                                            <th style="width: 250px;">Name</th>
                                            <td><input type="text" name="name" value="<?php echo e($applicant->name); ?>" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Qualification</th>
                                            <td><input type="text" name="qualification" value="<?php echo e($applicant->qualification); ?>" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Phone</th>
                                            <td><input type="text" name="phone" value="<?php echo e($applicant->phone); ?>" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Email</th>
                                            <td><input type="email" name="email" value="<?php echo e($applicant->email); ?>" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Address</th>
                                            <td><textarea name="address" class="form-control" rows="2"><?php echo e($applicant->address); ?></textarea></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Assigned To</th>
                                            <td>
                                                <select name="assigned_to" class="form-control">
                                                    <option value="">-- Select User --</option>
                                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($user->id); ?>" <?php echo e($applicant->assigned_to == $user->id ? 'selected' : ''); ?>>
                                                            <?php echo e($user->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Created From</th>
                                            <td><input type="text" name="created_from" value="<?php echo e($applicant->created_from); ?>" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Status</th>
                                            <td>
                                                <select name="status" class="form-control">
                                                    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($status->status); ?>" <?php echo e($applicant->status === $status->status ? 'selected' : ''); ?>>
                                                            <?php echo e($status->status_name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Notes</th>
                                            <td><textarea name="notes" id="notes" class="form-control" rows="3"><?php echo e($applicant->notes); ?></textarea></td>
                                        </tr>
                                        <tr>
                                            <td colspan="2" class="text-end">
                                                <a href="<?php echo e(route('applicants.index')); ?>" class="btn btn-outline-secondary">Cancel</a>
                                                <button type="submit" class="btn btn-primary px-4">Update</button>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- CKEditor Script -->
<script src="https://cdn.ckeditor.com/4.20.2/standard/ckeditor.js"></script>
<script>
    CKEDITOR.replace('notes');
</script>

<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /var/www/html/bigboy/resources/views/applicants/edit.blade.php ENDPATH**/ ?>