<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('title', 'Dashboard'); ?>

<div class="panel panel-primary">
    <div class="panel-heading">Dashboard</div>
    <div class="panel-body">
        
        
        <div class="panel panel-primary">
          <div class="panel-heading">Widgets</div>
          <div class="panel-body">
              
               <div class="row">
            <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(url('/applicants')); ?>?status=<?php echo e($status->status); ?>&label=<?php echo e($status->status_name); ?>">
                    <div class="col-md-4 col-sm-6">
                        <div class="info-card" style="border-left-color: #3498db;">
                            <span class="icon"><i class="fa fa-users"></i></span>
                            <h4><?php echo e($status->status_name); ?></h4>
                            <p><?php echo e($applicantCounts[$status->status_name] ?? 0); ?> Applicants</p>
                        </div>
                    </div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
              
              
          </div>
        </div>
        
        
        <!-- Widget Cards -->
       
        
        <div class="panel panel-primary">
          <div class="panel-heading">Chart</div>
          <div class="panel-body">
              
              <div class="row mt-4">
            <div class="col-md-12" style="height: 300px;">
                <canvas id="applicantStatusChart"></canvas>
            </div>
        </div>
              
              
          </div>
        </div>
        <div class="panel panel-primary">
                                          <div class="panel-heading">Followups(Today)</div>
                                          <div class="panel-body">
                                              <table class="table table-bordered" id="followups">
    <thead>
        <tr>
            <th>Id</th>
            <th>Application</th>
            <th>Followup Date</th>
            <th>Reason</th>
            <th>Status</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $followups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $followup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <form action="<?php echo e(route('followups.update')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <tr>
                    <td>
                        <input type="hidden" name="id" value="<?php echo e($followup->id); ?>">
                        <?php echo e($followup->id); ?>

                    </td>
                    <td>
                        <a href="<?php echo e(route('applicants.edit', $followup->application_id)); ?>" class="btn btn-sm btn-warning">
                            Edit (<?php echo e($followup->application_id); ?>)
                        </a>
                    </td>
                    <td><?php echo e($followup->followup_date); ?></td>
                    <td><?php echo e($followup->followup_reason); ?></td>
                    <td>
                        <select name="status" class="form-control">
                            <option value="Pending" <?php echo e($followup->status == 'Pending' ? 'selected' : ''); ?>>Pending</option>
                            <option value="Done" <?php echo e($followup->status == 'Done' ? 'selected' : ''); ?>>Done</option>
                        </select>
                    </td>
                    <td>
                        <button type="submit" class="btn btn-primary px-4">Update</button>
                    </td>
                </tr>
            </form>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

                                             
                                          </div>
                                        </div>
        <!-- Recent Activities -->
        <div class="panel panel-default mt-4">
            <div class="panel-heading">Today Events</div>
            <div class="panel-body">
                <?php if($recentApplicants->isEmpty()): ?>
                    <p>No recent activities recorded.</p>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="recent">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Qualification</th>
                                    <th>Phone</th>
                                    <th>Email</th>
                                    <th>Status</th>
                                    <th>Created At</th>
                                    <th>Edit</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $recentApplicants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $applicant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                        <td><?php echo e($applicant->name); ?></td>
                                        <td><?php echo e($applicant->qualification); ?></td>
                                        <td><?php echo e($applicant->phone); ?></td>
                                        <td><?php echo e($applicant->email); ?></td>
                                        <td>
                                            <span class="badge badge-secondary">
                                                <?php echo e(strtoupper(preg_replace('/[^A-Za-z0-9]+/', ' ', $applicant->status))); ?>

                                            </span>
                                        </td>
                                        <td><?php echo e($applicant->created_at->format('Y-m-d H:i')); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('applicants.edit', $applicant->id)); ?>" class="btn btn-sm btn-warning">
                                        Edit 
                        </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>

    </div>
</div>

<!-- Chart.js CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const ctx = document.getElementById('applicantStatusChart').getContext('2d');

        // Prepare PHP arrays for JS
        const statuses = <?php echo json_encode($statuses->pluck('status_name'), 15, 512) ?>;
        
        // Map counts in PHP, then pass to JS
        const counts = <?php echo json_encode(
            $statuses->map(function($status) use ($applicantCounts) {
                return $applicantCounts[$status->status_name] ?? 0;
            })
        , 15, 512) ?>;

        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: statuses,
                datasets: [{
                    label: 'Number of Applicants',
                    data: counts,
                    backgroundColor: 'rgba(52, 152, 219, 0.7)',
                    borderColor: 'rgba(52, 152, 219, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1
                        }
                    }
                },
                plugins: {
                    legend: { display: false },
                    title: {
                        display: true,
                        text: 'Applicants Count by Status'
                    }
                },
                responsive: true,
                maintainAspectRatio: false,
            }
        });
    });
</script>

<script>
    $(document).ready(function () {
        $('#followups').DataTable();
    });
</script>
<script>
    $(document).ready(function () {
        $('#recent').DataTable();
    });
</script>

<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/crmbigboyschool/public_html/crm/resources/views/home.blade.php ENDPATH**/ ?>