<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ApplicantController;
use App\Http\Controllers\StatusController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProfileController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});






Auth::routes();
Route::match(['get', 'post'], '/register', function () {
    abort(403, 'Registration is disabled.');
});

Route::middleware(['auth'])->group(function () {
    Route::get('/home', [HomeController::class, 'index'])->name('home');

    Route::get('/applicants', [ApplicantController::class, 'index'])->name('applicants.index');
    
    
    
     Route::post('/followups', [ApplicantController::class, 'followup_store'])->name('followups.store');
     Route::post('/followups-update', [ApplicantController::class, 'followup_update'])->name('followups.update');
    
    
    Route::get('/applicants/{id}', [ApplicantController::class, 'show'])->name('applicants.show');
    Route::get('/applicants/{id}/edit', [ApplicantController::class, 'edit'])->name('applicants.edit');
    Route::put('/applicants/{id}', [ApplicantController::class, 'update'])->name('applicants.update');

    Route::get('/statuses', [StatusController::class, 'index'])->name('statuses.index');
    Route::get('/statuses/create', [StatusController::class, 'create'])->name('statuses.create');
    Route::post('/statuses', [StatusController::class, 'store'])->name('statuses.store');
    Route::delete('/statuses/{status}', [StatusController::class, 'destroy'])->name('statuses.destroy');

    Route::get('/whatsapp-link', [HomeController::class, 'link_whatsapp'])->name('link_whatsapp');

    Route::get('/upload-applicants', [ApplicantController::class, 'showUploadForm']);
    Route::post('/upload-applicants', [ApplicantController::class, 'uploadCSV'])->name('applicants.upload');

    Route::get('/users/create', [UserController::class, 'create'])->name('users.create');
    Route::post('/users', [UserController::class, 'store'])->name('users.store');
    
    
    Route::get('/change-password', [ProfileController::class, 'showChangePasswordForm'])->name('password.change');
    Route::post('/change-password', [ProfileController::class, 'changePassword'])->name('password.update');
    
});


