
@include('layouts.header')

<div class="panel panel-primary">
      <div class="panel-heading">Create User</div>
      <div class="panel-body">
          @if(session('success'))
                <p style="color:green">{{ session('success') }}</p>
            @endif
            @if ($errors->any())
    <div class="alert alert-danger">
        <strong>There were some problems with your input:</strong>
        <ul class="mb-0 mt-2">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
        
            <form method="POST" action="{{ route('users.store') }}">
        @csrf

        <div class="mb-3">
            <label>Name</label>
            <input type="text" name="name" class="form-control" required>
            @error('name') <small class="text-danger">{{ $message }}</small> @enderror
        </div>

        <div class="mb-3">
            <label>Email</label>
            <input type="email" name="email" class="form-control" required>
            @error('email') <small class="text-danger">{{ $message }}</small> @enderror
        </div>

        <div class="mb-3">
            <label>Password</label>
            <input type="password" name="password" class="form-control" required>
            @error('password') <small class="text-danger">{{ $message }}</small> @enderror
        </div>

        <div class="mb-3">
            <label>Role</label>
            <select name="group_id" class="form-control" required>
                <option value="">Select Role</option>
                <option value="1">Admin</option>
                <option value="2">User</option>
            </select>
            <br>
            <br>
            @error('role') <small class="text-danger">{{ $message }}</small> @enderror
        </div>

        <button type="submit" class="btn btn-primary">Create User</button>
    </form>
      </div>
</div>








<div class="panel panel-primary">
      <div class="panel-heading">User list</div>
      <div class="panel-body">
           <table class="table table-bordered table-striped" id="userTable">
        <thead class="table-light">
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Email</th>
                <th>Role</th>
                <th>Created On</th>
            </tr>
        </thead>
        <tbody>
            @forelse($users as $user)
                <tr>
                    <td>{{ $user->id }}</td>
                    <td>{{ $user->name }}</td>
                    <td>{{ $user->email }}</td>
                    <td>
                        <?php
                        if($user->group_id == 1)
                        {
                        ?>
                            <b>Admin</b>
                        <?php
                        }
                        else
                        {
                        ?>
                            <b>User</b>
                        <?php
                        }
                        ?>
                    </td>
                    <td>{{ $user->created_at->format('Y-m-d H:i') }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="5">No users found.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
      </div>
</div>
<script>
    $(document).ready(function () {
        $('#userTable').DataTable();
    });
</script>

@include('layouts.footer')

