@include('layouts.header')
<div class="panel panel-primary">
      <div class="panel-heading">All Events</div>
      <div class="panel-body">
            <a href="{{ route('statuses.create') }}" class="btn btn-primary mb-3">Add Event</a>
                <br></br>
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
            
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Event Name</th>
                            <th>Event Code</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($statuses as $status)
                        <tr>
                            <td>{{ $status->status_name }}</td>
                            <td>{{ $status->status }}</td>
                            <td>
                                <form action="{{ route('statuses.destroy', $status->id) }}" method="POST" onsubmit="return confirm('Are you sure to delete this status?');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="btn btn-danger btn-sm">Delete</button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
      </div>
</div>

@include('layouts.footer')
