@include('layouts.header')

@section('title', 'Dashboard')

<div class="panel panel-primary">
    <div class="panel-heading">Dashboard</div>
    <div class="panel-body">
        
        
        <div class="panel panel-primary">
          <div class="panel-heading">Widgets</div>
          <div class="panel-body">
              
               <div class="row">
            @foreach ($statuses as $status)
                <a href="{{ url('/applicants') }}?status={{ $status->status }}&label={{ $status->status_name }}">
                    <div class="col-md-4 col-sm-6">
                        <div class="info-card" style="border-left-color: #3498db;">
                            <span class="icon"><i class="fa fa-users"></i></span>
                            <h4>{{ $status->status_name }}</h4>
                            <p>{{ $applicantCounts[$status->status_name] ?? 0 }} Applicants</p>
                        </div>
                    </div>
                </a>
            @endforeach
        </div>
              
              
          </div>
        </div>
        
        
        <!-- Widget Cards -->
       
        
        <div class="panel panel-primary">
          <div class="panel-heading">Chart</div>
          <div class="panel-body">
              
              <div class="row mt-4">
            <div class="col-md-12" style="height: 300px;">
                <canvas id="applicantStatusChart"></canvas>
            </div>
        </div>
              
              
          </div>
        </div>
        <div class="panel panel-primary">
                                          <div class="panel-heading">Followups(Today)</div>
                                          <div class="panel-body">
                                              <table class="table table-bordered" id="followups">
    <thead>
        <tr>
            <th>Id</th>
            <th>Application</th>
            <th>Followup Date</th>
            <th>Reason</th>
            <th>Status</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @foreach($followups as $followup)
            <form action="{{ route('followups.update') }}" method="POST">
                @csrf
                <tr>
                    <td>
                        <input type="hidden" name="id" value="{{ $followup->id }}">
                        {{ $followup->id }}
                    </td>
                    <td>
                        <a href="{{ route('applicants.edit', $followup->application_id) }}" class="btn btn-sm btn-warning">
                            Edit ({{ $followup->application_id }})
                        </a>
                    </td>
                    <td>{{ $followup->followup_date }}</td>
                    <td>{{ $followup->followup_reason }}</td>
                    <td>
                        <select name="status" class="form-control">
                            <option value="Pending" {{ $followup->status == 'Pending' ? 'selected' : '' }}>Pending</option>
                            <option value="Done" {{ $followup->status == 'Done' ? 'selected' : '' }}>Done</option>
                        </select>
                    </td>
                    <td>
                        <button type="submit" class="btn btn-primary px-4">Update</button>
                    </td>
                </tr>
            </form>
        @endforeach
    </tbody>
</table>

                                             
                                          </div>
                                        </div>
        <!-- Recent Activities -->
        <div class="panel panel-default mt-4">
            <div class="panel-heading">Today Events</div>
            <div class="panel-body">
                @if($recentApplicants->isEmpty())
                    <p>No recent activities recorded.</p>
                @else
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="recent">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Qualification</th>
                                    <th>Phone</th>
                                    <th>Email</th>
                                    <th>Status</th>
                                    <th>Created At</th>
                                    <th>Edit</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($recentApplicants as $index => $applicant)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $applicant->name }}</td>
                                        <td>{{ $applicant->qualification }}</td>
                                        <td>{{ $applicant->phone }}</td>
                                        <td>{{ $applicant->email }}</td>
                                        <td>
                                            <span class="badge badge-secondary">
                                                {{ strtoupper(preg_replace('/[^A-Za-z0-9]+/', ' ', $applicant->status)) }}
                                            </span>
                                        </td>
                                        <td>{{ $applicant->created_at->format('Y-m-d H:i') }}</td>
                                        <td>
                                            <a href="{{ route('applicants.edit', $applicant->id) }}" class="btn btn-sm btn-warning">
                                        Edit 
                        </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif
            </div>
        </div>

    </div>
</div>

<!-- Chart.js CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const ctx = document.getElementById('applicantStatusChart').getContext('2d');

        // Prepare PHP arrays for JS
        const statuses = @json($statuses->pluck('status_name'));
        
        // Map counts in PHP, then pass to JS
        const counts = @json(
            $statuses->map(function($status) use ($applicantCounts) {
                return $applicantCounts[$status->status_name] ?? 0;
            })
        );

        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: statuses,
                datasets: [{
                    label: 'Number of Applicants',
                    data: counts,
                    backgroundColor: 'rgba(52, 152, 219, 0.7)',
                    borderColor: 'rgba(52, 152, 219, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1
                        }
                    }
                },
                plugins: {
                    legend: { display: false },
                    title: {
                        display: true,
                        text: 'Applicants Count by Status'
                    }
                },
                responsive: true,
                maintainAspectRatio: false,
            }
        });
    });
</script>

<script>
    $(document).ready(function () {
        $('#followups').DataTable();
    });
</script>
<script>
    $(document).ready(function () {
        $('#recent').DataTable();
    });
</script>

@include('layouts.footer')
