@include('layouts.header')

<style>
    body, html {
        margin: 0;
        padding: 0;
    }

    .full-screen-panel {
        width: 100%;
        padding: 20px;
    }

    .panel {
        width: 100%;
    }
</style>
<br></br>
<div class="full-screen-panel">
    <div class="alert alert-info">
    <?php
    $label = $_GET['label'];
    ?>
      <strong>{{$label}} List</strong>
    </div>
   
    <div class="panel panel-primary">
      <div class="panel-heading">Filter with dates</div>
      <div class="panel-body">
          
          <!-- Filter Section -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <label>From Date</label>
                    <input type="date" id="from_date" class="form-control">
                </div>
                <div class="col-md-3">
                    <label>To Date</label>
                    <input type="date" id="to_date" class="form-control">
                </div>
                <div class="col-md-3">
                    <label>&nbsp;</label><br>
                    <button type="button" id="filter" class="btn btn-primary">Filter</button>
                    <button type="button" id="reset" class="btn btn-secondary">Reset</button>
                </div>
            </div>
          
          
      </div>
    </div>
    
    
    
    

    <!-- Table Section -->
    <div class="panel panel-primary">
        <div class="panel-heading">All Leads</div>
        <div class="panel-body">
            <table id="applicants-table" class="table table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Attended By</th>
                        <th>Name</th>
                        <th>Qualification</th>
                        <th>Phone</th>
                        <th>Email</th>
                        <th>Created On</th>
                        <th>Action</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>

</div>

<!-- DataTables Script -->
<script>
    var table = $('#applicants-table').DataTable({
        processing: true,
        serverSide: true,
        pageLength: 100,
        ajax: {
            url: "{{ route('applicants.index') }}",
            data: function(d) {
                d.status = "{{ $status }}";
                d.from_date = $('#from_date').val();
                d.to_date = $('#to_date').val();
            }
        },
        columns: [
            { data: 'id' },
            {
                data: 'asigned_to',
                render: function(data, type, row) {
                    if (data === "Not Available") {
                        return '<span style="color: red;">' + data + '</span>';
                    } else {
                        return '<b><span style="color: blue;"><span class="glyphicon glyphicon-user"></span>&nbsp;' + data + '</span></b>';
                    }
                }
            },
            { data: 'name' },
            { data: 'qualification' },
            { data: 'phone' },
            { data: 'email' },
            { data: 'created_from' },
            { data: 'action', orderable: false, searchable: false }
        ],
        order: [[0, 'desc']],
        dom: 'Blfrtip',
        buttons: ['csvHtml5']
    });

    $('#filter').click(function() {
        table.draw();
    });

    $('#reset').click(function() {
        $('#from_date').val('');
        $('#to_date').val('');
        table.draw();
    });

    setInterval(function () {
        table.ajax.reload(null, false);
    }, 5000);
</script>

@include('layouts.footer')
