@include('layouts.header')

<div class="panel panel-primary">
    <div class="panel-heading">Edit Application</div>
    <div class="panel-body">
        <div class="container my-5">
            <div class="row justify-content-center">
                @if (session('success'))
    <div class="alert alert-success alert-dismissable">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        {{ session('success') }}
    </div>
@endif

@if (session('error'))
    <div class="alert alert-danger alert-dismissable">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        {{ session('error') }}
    </div>
@endif

@if ($errors->any())
    <div class="alert alert-danger alert-dismissable">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <strong>Whoops! Something went wrong:</strong>
        <ul class="mb-0 mt-2">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

                <div class="col-md-10">
                    <form action="{{ route('applicants.update', $applicant->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="card shadow-lg border-0 rounded-4 bg-white">
                            <div class="card-body p-4 bg-light-subtle">
                                <div class="panel panel-primary">
                                  <div class="panel-heading">Update Lead</div>
                                  <div class="panel-body">
                                      
                                      <table class="table table-bordered">
                                    <tbody>
                                        <tr style="background-color: #e0ebeb;">
                                            <th style="width: 250px;">Name</th>
                                            <td><input type="text" name="name" value="{{ $applicant->name }}" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Qualification</th>
                                            <td><input type="text" name="qualification" value="{{ $applicant->qualification }}" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Phone</th>
                                            <td><input type="text" name="phone" value="{{ $applicant->phone }}" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Email</th>
                                            <td><input type="text" name="email" value="{{ $applicant->email }}" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Address</th>
                                            <td><textarea name="address" class="form-control" rows="2">{{ $applicant->address }}</textarea></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Attended by </th>
                                            <td>
                                                <div class="alert alert-info">
                                               <span class="glyphicon glyphicon-user"></span>
                                               {{ $applicant->asigned_to }}
                                            </div>
                                                
                                            </td>
                                        </tr>
                                        <th style="background-color: #e0ebeb;">
                                            Course
                                        </th>
                                        <td>
                                             <select class="form-control" name="course">
                                                    <option>-Add or change course-</option>
                                                    <?php
                                                    foreach($courses as $course)
                                                    {
                                                        ?>
                                                        <option value="{{$course->Name}}">{{$course->Name}}</option>
                                                        <?php
                                                    }
                                                    ?>
                                             </select>
                                        </td>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Course Selected</th>
                                        <td>
                                            
                                            <div class="alert alert-info">
                                               {{ $applicant->course }}
                                            </div>
                                            
                                            </td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Created From</th>
                                            <td><input type="text" name="created_from" value="{{ $applicant->created_from }}" class="form-control"></td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Status</th>
                                            <td>
                                                <select name="status" class="form-control">
                                                    @foreach($statuses as $status)
                                                        <option value="{{ $status->status }}" {{ $applicant->status === $status->status ? 'selected' : '' }}>
                                                            {{ $status->status_name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #e0ebeb;">Notes</th>
                                            <td><textarea name="notes" id="notes" class="form-control" rows="3">{{ $applicant->notes }}</textarea></td>
                                        </tr>
                                        <tr>
                                            <th>Scheduled to </th>
                                            <td>
                                                
                                                <input class="form-control" type="date" value = "{{ $applicant->scheduled_to }}" name="scheduled_to">
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2" class="text-end">
                                                <a href="{{ route('applicants.index') }}" class="btn btn-outline-secondary">Cancel</a>
                                                <button type="submit" class="btn btn-primary px-4">Update Lead</button>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                      
                                      
                                  </div>
                                </div>
                                
                                
                                
                                
                                

                            </div>
                        </div>
                    </form>
                    <table class="table table-bordered">
                        <tr>
                                            <td colspan="2">
                                                
                                                <div class="panel panel-primary">
                                          <div class="panel-heading">Followups</div>
                                          <div class="panel-body">
                                              <table class="table table-bordered">
                                                  <tr>
                                                      <th>Id</th>
                                                      <th>Application</th>
                                                      <td>Followup Date</td>
                                                      <th>Reason</th>
                                                      <th>Status</th>
                                                      <th>Action</th>
                                                  </tr>
                                              <?php
                                              
                                                  
                                                  foreach($followups as     $followup)
                                            {
                                              ?>
                                              <tr>
                                                  <form action="{{ route('followups.update') }}" method="POST">
                                        @csrf
                                                  <td><input name="id" type="hidden" value="{{$followup->id}}">{{$followup->id}}</td>
                                                  <td>{{$followup->application_id}}</td>
                                                  <td>{{$followup->followup_date}}</td>
                                                  <td>{{$followup->followup_reason}}</td>
                                                  <td>
                                                      <select name="status" class="form-control">
                                                          <option <?php if ($followup->status == "Pending"){ echo "selected";} ?>>Pending    </option>
                                                          <option <?php if ($followup->status == "Done"){ echo "selected";} ?>>Done</option>
                                                          
                                                      </select>
                                                  </td>
                                                  <td><button class="btn btn-primary px-4">Update</button></td>
                                              </tr>
                                              <?php
                                              }
                                              ?>
                                              </table> 
                                             
                                          </div>
                                        </div>
                                                
                                                
                                            </td>
                                        </form>
                                        </tr>
                                        <tr>
                                            <td colspan="2">
                                                <div class="panel panel-primary">
                                          <div class="panel-heading">New followup</div>
                                          <div class="panel-body">
                                              
                                              <form action="{{ route('followups.store') }}" method="POST">
                                            @csrf
                                            <label>Application ID:</label><br>
                                            <input value="{{ $applicant->id }}" readonly type="number" name="application_id" required class="form-control"><br>
                                    
                                            <label>Followup Date:</label><br>
                                            <input class="form-control" type="date" name="followup_date" required><br>
                                    
                                            <label>Followup Reason:</label><br>
                                            <input class="form-control" type="text" name="followup_reason" required><br>
                                    
                                            <label>Status:</label><br>
                                            <select class="form-control" name="status">
                                                <option value="pending">Pending</option>
                                                <option value="Done">Done</option>
                                                
                                            </select><br>
                                    
                                            <button class="btn btn-success px-4" type="submit">Create</button>
                                        </form>
                                              
                                          </div>
                                        </div>
                                                 
                                            </td>
                                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- CKEditor Script -->
<script src="https://cdn.ckeditor.com/4.20.2/standard/ckeditor.js"></script>
<script>
    CKEDITOR.replace('notes');
</script>

@include('layouts.footer')
