<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApplicantsTable extends Migration
{
    public function up()
    {
        Schema::create('applicants', function (Blueprint $table) {
            $table->id(); // 'id' field (auto-increment primary key)
            $table->string('name');
            $table->string('qualification')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->text('address')->nullable();
            $table->string('asigned_to')->nullable();
            $table->string('created_from')->nullable();
            $table->string('status')->default('pending');
            $table->text('notes')->nullable(); // <-- New field added here
            $table->timestamps(); // created_at & updated_at
        });
    }

    public function down()
    {
        Schema::dropIfExists('applicants');
    }
}
