<?php

// app/Http/Controllers/StatusController.php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Status;

class StatusController extends Controller
{
    public function index()
    {
        $statuses = Status::all();
        return view('statuses.index', compact('statuses'));
    }

    public function create()
    {
        return view('statuses.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'status_name' => 'required|string|max:255',
            'status' => 'required|string|max:255|unique:statuses,status',
        ]);

        Status::create($request->only(['status_name', 'status']));
        return redirect()->route('statuses.index')->with('success', 'Status created successfully.');
    }

    public function destroy(Status $status)
    {
        $status->delete();
        return redirect()->route('statuses.index')->with('success', 'Status deleted successfully.');
    }
}

