<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Applicant;
use App\Models\Status;
use App\Models\Followup;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $today = date("Y-m-d");
        $statuses = Status::all();

        $applicantCounts = [];

        foreach ($statuses as $status) {
            $count = Applicant::where('status', $status->status)->count();
            $applicantCounts[$status->status_name] = $count;
        }

        // Fetch last 50 applicants ordered by latest created_at or id
        $recentApplicants = Applicant::where("scheduled_to",'like',"%$today%")->get();
        
        $followups = Followup::where('followup_date','like',"%$today%")->get();
        
        return view('home', compact('statuses', 'applicantCounts', 'recentApplicants','followups'));
    }
    
    public function link_whatsapp(Request $request)
    {
        $whatsappApi = env('WHATSAPP_API');
        $url = $whatsappApi;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        $whatsapp_data = json_decode($response,true);
        curl_close($ch);
        $qr_url = $whatsapp_data["qr_url"];
        header("Location: $qr_url");
        exit();
        
    }

}
