<?php

namespace App\Http\Controllers;

use App\Models\Applicant;
use App\Models\Status;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use App\Models\User;
use Illuminate\Support\Facades\Validator;
use App\Models\Followup;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use DB;


class ApplicantController extends Controller
{
    public function showUploadForm()
    {
        return view('applicants.upload_applicants');
    }
    
    public function uploadCSV(Request $request)
    {
        $request->validate([
            'csv_file' => 'required|file|mimes:csv,txt'
        ]);

        $file = fopen($request->file('csv_file'), 'r');
        $header = fgetcsv($file); // Get header row

        while (($row = fgetcsv($file)) !== FALSE) {
            $data = array_combine($header, $row);

            // Insert only allowed fields
            Applicant::create([
                'name' => $data['name'] ?? null,
                'qualification' => $data['qualification'] ?? null,
                'phone' => $data['phone'] ?? null,
                'email' => $data['email'] ?? null,
                'address' => $data['address'] ?? null,
                'asigned_to' => $data['asigned_to'] ?? null,
                'created_from' => $data['created_from'] ?? null,
                'status' => $data['status'] ?? null,
                'notes' => $data['notes'] ?? null,
            ]);
        }

        fclose($file);

        return back()->with('success', 'Applicants uploaded successfully!');
    }
    
    public function set_data(Request $request)
    {
        $phone = $request->phone;
         $applicant = Applicant::create([
            'name'          => "Not Available",
            'qualification' => "Not Available",
            'phone'         => $phone,
            'email'         => "Not Available",
            'address'       => "Not Available",
            'asigned_to'    => "Not Available",
            'created_from'  => "Whatsapp",
            'status'        => "whatsapp_leads",
            'notes'         => "Not Available",
        ]);
        return array("status"=>true,"message"=>"updated");
    }
    public function index(Request $request)
    {
        $status = $request->status;
    
        if ($request->ajax()) {
            $current_authenticated_user = Auth::user()->name;
            $group_id = Auth::user()->group_id;
            $query = Applicant::query();
    
            if ($status) {
                if($group_id != 1)
                {
                            $query->where('status', $status)
                  ->where(function($q) use ($current_authenticated_user) {
                      $q->where('asigned_to', $current_authenticated_user)
                        ->orWhere('asigned_to', 'Not Available');
                  });
                }
                else
                {
                    $query->where('status', $status);
                }
            }
    
            // Date filter
            if ($request->filled('from_date')) {
                $query->whereDate('created_at', '>=', $request->from_date);
            }
    
            if ($request->filled('to_date')) {
                $query->whereDate('created_at', '<=', $request->to_date);
            }
    
            $data = $query->latest()->get();
    
            return DataTables::of($data)
                ->addColumn('created_from', function ($row) {
                    return $row->created_at->format('Y-m-d');
                })
                ->addColumn('action', function ($row) {
                    $viewBtn = '<a href="'.route('applicants.show', $row->id).'" class="btn btn-sm btn-info">View</a>';
                    $editBtn = '<a href="'.route('applicants.edit', $row->id).'" class="btn btn-sm btn-warning">Edit</a>';
                    return $viewBtn . ' ' . $editBtn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
    
        return view('applicants.index', ['status' => $status]);
    }


    public function show($id)
    {
        $applicant = Applicant::findOrFail($id);
        return view('applicants.show', compact('applicant'));
    }

    public function edit($id)
    {
        $courses = DB::table("Courses")->get();
        $current_authenticated_user = Auth::user()->name;
        
        $applicant = Applicant::findOrFail($id);
        if($applicant->asigned_to == "Not Available")
        {
            $applicant->asigned_to = $current_authenticated_user;
            $applicant->save();
        }
        $statuses = Status::all();  // Get all statuses
        $users = User::all();       // Get all users to assign
        $followups = Followup::where('application_id', $id)->get();
        
        return view('applicants.edit', compact('applicant', 'statuses', 'users','followups','courses'));
    }


    public function update(Request $request, $id)
    {
        
        $request->validate([
            'name' => 'required|string|max:255',
            'qualification' => 'nullable|string|max:255',
            'phone' => 'nullable|string|max:20',
            'email' => 'nullable',
            'address' => 'nullable|string',
            'assigned_to' => 'nullable|string',
            'created_from' => 'nullable|string',
            'status' => 'required|string',
            'notes' => 'nullable|string',
            'course'=>'nullable|string',
            'scheduled_to' =>'nullable|string',
        ]);

        $applicant = Applicant::findOrFail($id);
        $applicant->update($request->all());

        return redirect()->route('applicants.show', $id)
                        ->with('success', 'Applicant updated successfully');
    }
    
    
   public function followup_store(Request $request)
    {
        $validated = $request->validate([
            'application_id' => 'required|integer',
            'followup_date' => 'required|date',
            'followup_reason' => 'required|string',
            'status' => 'required|string',
        ]);

        Followup::create($validated);

        return redirect()->back()->with('success', 'Followup created successfully!');
    }
    
    public function followup_update(Request $request)
    {
        $id = $request->id;
        $validated = $request->validate([
        'status'           => 'required|string',
        ]);

        $followup = Followup::findOrFail($id);
        $followup->update($validated);
        return redirect()->back()->with('success', 'Followup updated successfully!');
        
    }
    
    


}
