<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Applicant;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;


class Whatsapp
{
    public static function add_contact()
    {
        // Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
        $ch = curl_init();
        
        curl_setopt($ch, CURLOPT_URL, 'https://live-mt-server.wati.io/445714/api/v1/addContact/919349444344');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "\n{\n  \"name\": \"Sibin\",\n  \"customParams\": [\n    {\n      \"name\": \"Host\",\n      \"value\": \"true\"\n    }\n  ]\n}\n");
        
        $headers = array();
        $headers[] = 'Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiIxYWU5MTI5Yi1iN2NiLTRkMGUtOTllMi1iMDBjZDEyYzliNTUiLCJ1bmlxdWVfbmFtZSI6ImFkbWluQGJpZ2JveXNjaG9vbC5jb20iLCJuYW1laWQiOiJhZG1pbkBiaWdib3lzY2hvb2wuY29tIiwiZW1haWwiOiJhZG1pbkBiaWdib3lzY2hvb2wuY29tIiwiYXV0aF90aW1lIjoiMDYvMTEvMjAyNSAwODoxNjowMiIsInRlbmFudF9pZCI6IjQ0NTcxNCIsImRiX25hbWUiOiJtdC1wcm9kLVRlbmFudHMiLCJodHRwOi8vc2NoZW1hcy5taWNyb3NvZnQuY29tL3dzLzIwMDgvMDYvaWRlbnRpdHkvY2xhaW1zL3JvbGUiOiJBRE1JTklTVFJBVE9SIiwiZXhwIjoyNTM0MDIzMDA4MDAsImlzcyI6IkNsYXJlX0FJIiwiYXVkIjoiQ2xhcmVfQUkifQ.Siz6Z1YtsfTtzc_1KzllqoH0Z6XIkjaZitMMw39iv7s';
        $headers[] = 'Content-Type: application/json-patch+json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

    }
    public static function sent($message)
    {
        $ch = curl_init();

        $encodedMessage = urlencode($message);

        curl_setopt($ch, CURLOPT_URL, 'https://live-mt-server.wati.io/445714/api/v1/sendSessionMessage/919349444344?messageText=' . $encodedMessage);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);

        $headers = [
            'Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiIxYWU5MTI5Yi1iN2NiLTRkMGUtOTllMi1iMDBjZDEyYzliNTUiLCJ1bmlxdWVfbmFtZSI6ImFkbWluQGJpZ2JveXNjaG9vbC5jb20iLCJuYW1laWQiOiJhZG1pbkBiaWdib3lzY2hvb2wuY29tIiwiZW1haWwiOiJhZG1pbkBiaWdib3lzY2hvb2wuY29tIiwiYXV0aF90aW1lIjoiMDYvMTEvMjAyNSAwODoxNjowMiIsInRlbmFudF9pZCI6IjQ0NTcxNCIsImRiX25hbWUiOiJtdC1wcm9kLVRlbmFudHMiLCJodHRwOi8vc2NoZW1hcy5taWNyb3NvZnQuY29tL3dzLzIwMDgvMDYvaWRlbnRpdHkvY2xhaW1zL3JvbGUiOiJBRE1JTklTVFJBVE9SIiwiZXhwIjoyNTM0MDIzMDA4MDAsImlzcyI6IkNsYXJlX0FJIiwiYXVkIjoiQ2xhcmVfQUkifQ.Siz6Z1YtsfTtzc_1KzllqoH0Z6XIkjaZitMMw39iv7s',
        ];

        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }

        curl_close($ch);
    }
}


class ReportSend extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'report:send';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
   public function handle()
    {
        $today = \Carbon\Carbon::today()->toDateString();
        $report_template = "📅 Daily Report ($today)";
    
        // Total leads created today
        $total_leads = \App\Models\Applicant::whereDate('created_at', $today)->count();
        $report_template .= "\n📈 Total Leads: $total_leads";
    
        // Grouped leads by assigned person
        $grouped = \App\Models\Applicant::select('asigned_to', \DB::raw('count(*) as total'))
            ->whereDate('created_at', $today)
            ->groupBy('asigned_to')
            ->get();
    
        foreach ($grouped as $assigned) {
            $assigned_to = $assigned->asigned_to;
    
            if (empty($assigned_to) || $assigned_to === "Not Available") {
                $status_name = "❌ Unattended";
            } else {
                $status_name = "👤 $assigned_to";
            }
    
            $report_template .= "\n$status_name: {$assigned->total}";
        }
        Whatsapp::add_contact();
        Whatsapp::sent($report_template);
        //echo $report_template;
        return 0;
    }
}
