<?php

namespace App\Console\Commands;
use App\Models\Applicant;

use Illuminate\Console\Command;

class GetWattiContactsCurl extends Command
{
    protected $signature = 'watti:get-contacts-curl';
    protected $description = 'Fetch contacts from Watti API using cURL';

    public function handle()
    {
        $current_date = date("Y-m-d");
        // Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
        $ch = curl_init();
        
        curl_setopt($ch, CURLOPT_URL, 'https://live-mt-server.wati.io/445714/api/v1/getContacts?createdDate='.$current_date);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        
        
        $headers = array();
        $headers[] = 'Accept: */*';
        $headers[] = 'Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiIxYWU5MTI5Yi1iN2NiLTRkMGUtOTllMi1iMDBjZDEyYzliNTUiLCJ1bmlxdWVfbmFtZSI6ImFkbWluQGJpZ2JveXNjaG9vbC5jb20iLCJuYW1laWQiOiJhZG1pbkBiaWdib3lzY2hvb2wuY29tIiwiZW1haWwiOiJhZG1pbkBiaWdib3lzY2hvb2wuY29tIiwiYXV0aF90aW1lIjoiMDYvMTEvMjAyNSAwODoxNjowMiIsInRlbmFudF9pZCI6IjQ0NTcxNCIsImRiX25hbWUiOiJtdC1wcm9kLVRlbmFudHMiLCJodHRwOi8vc2NoZW1hcy5taWNyb3NvZnQuY29tL3dzLzIwMDgvMDYvaWRlbnRpdHkvY2xhaW1zL3JvbGUiOiJBRE1JTklTVFJBVE9SIiwiZXhwIjoyNTM0MDIzMDA4MDAsImlzcyI6IkNsYXJlX0FJIiwiYXVkIjoiQ2xhcmVfQUkifQ.Siz6Z1YtsfTtzc_1KzllqoH0Z6XIkjaZitMMw39iv7s';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        
        $result = curl_exec($ch);
        $json_result = json_decode($result,true)["contact_list"];
        foreach($json_result as $contacts)
        {
            $phone_number = $contacts["phone"];
            $phone = $phone_number;

            // Check if applicant with the given phone number already exists
            $existingApplicant = Applicant::where('phone', $phone)->first();
            
            if (!$existingApplicant) {
                $applicant = Applicant::create([
                    'name'          => "Not Available",
                    'qualification' => "Not Available",
                    'phone'         => $phone,
                    'email'         => "Not Available",
                    'address'       => "Not Available",
                    'asigned_to'    => "Not Available",
                    'created_from'  => "Whatsapp",
                    'status'        => "whatsapp_leads",
                    'notes'         => "Not Available",
                ]);
                print("[+] NEW CONTACT $phone (UPDATED TO CRM )");
                print("\n");
            }
            
        }
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

        
        

    }
}

